document.addEventListener("DOMContentLoaded", function () {
  // --- Render Functions ---
  const createPlaceholder = (text = "Placeholder") =>
    `<div class="placeholder">${text}</div>`;

  // --- Populate Header ---
  document.querySelector(
    "header"
  ).innerHTML = `<div class="logo">${pageData.header.logo}</div>`;

  // --- Populate Top Section ---
  const topSection = document.querySelector(".top-section");
  topSection.innerHTML = `
        <div class="card">
            <div class="placeholder-column"><img src="/assets/images/1-min.png" alt="..." width="200" height="200"></div>
            <div class="text-column">
                <h1>${pageData.topSection.title}</h1>
                <p>${pageData.topSection.description}</p>
                <div>
                    <button class="btn-primary">${pageData.topSection.buttons.primary}</button>
                    <button class="btn-secondary">${pageData.topSection.buttons.secondary}</button>
                </div>
            </div>
            <div class="placeholder-column">
            <img src="/assets/images/top-left.png" alt="..." width="300" height="200">
            </div>
        </div>
    `;

  // --- Populate Middle Section ---
  const middleSection = document.querySelector(".middle-section");
  let tabButtons = "";
  let tabContents = "";
  pageData.middleSection.tabs.forEach((tab, index) => {
    const activeClass = index === 0 ? "active" : "";

    const featureItems = tab.features
      .map((feature) => `<li class="item">${feature}</li>`)
      .join("");

    tabButtons += `<button class="tab-btn ${activeClass}" data-tab="${index}">${tab.button}</button>`;
    tabContents += `
            <div class="tab-content ${activeClass}" data-tab="${index}">
                <div class="tab-content-inner">
                    <div class="text-content">
                        <p>${tab.description}</p>
                        <h3>${tab.contentTitle}</h3>
                        <ul class="grid-2x2">
                           ${featureItems}
                        </ul>

                    </div>
                    <div class="placeholder-column">
                    <img src="/assets/images/left.png" alt="..." width="360" height="250">
                    </div>
                </div>
            </div>
        `;
  });

  middleSection.innerHTML = `
        <h2 class="section-title">${pageData.middleSection.title}</h2>
        <div class="tabs-layout">
            <div class="tab-buttons">${tabButtons}</div>
            <div class="tab-content-wrapper">${tabContents}</div>
        </div>
    `;

  // --- Tab Functionality ---
  const tabLayout = document.querySelector(".tabs-layout");
  tabLayout.addEventListener("click", (e) => {
    if (e.target.matches(".tab-btn")) {
      const tabId = e.target.dataset.tab;
      tabLayout
        .querySelectorAll(".tab-btn")
        .forEach((btn) => btn.classList.remove("active"));
      e.target.classList.add("active");

      tabLayout.querySelectorAll(".tab-content").forEach((content) => {
        content.classList.toggle("active", content.dataset.tab === tabId);
      });
    }
  });

  // --- Populate Bottom Section ---
  const bottomSection = document.querySelector(".bottom-section");
  let columnsHtml = "";
  pageData.bottomSection.columns.forEach((col) => {
    columnsHtml += `
            <div class="column-card">
                <img src="/assets/images/bottom.png" alt="..." width="320" height="140">
                <h4>${col.title}</h4>
                <p>${col.text}</p>
            </div>
        `;
  });
  bottomSection.innerHTML = `
        <br/><br/>
        <div class="columns-layout">${columnsHtml}</div>
    `;

  // --- Populate Footer ---
  document.querySelector(
    "footer"
  ).innerHTML = `<p>${pageData.footer.copyright}</p>`;
});
